local Platform = {}


-- Distribution platforms

function Platform.IsPS4()
	return PLATFORM == "PS4"
end

function Platform.IsXB1()
	return PLATFORM == "XBONE"
end

function Platform.IsSteam()
	return PLATFORM == "WIN32_STEAM" or PLATFORM == "LINUX_STEAM" or Platform.IsMac()
end

function Platform.IsRail()
	return PLATFORM == "WIN32_RAIL"
end


-- Operating systems

function Platform.IsWindows()
	return PLATFORM == "WIN32_STEAM" or PLATFORM == "WIN32_RAIL"
end

function Platform.IsLinux()
	return PLATFORM == "LINUX_STEAM"
end

function Platform.IsAndroid()
	return PLATFORM == "ANDROID"
end

function Platform.IsIos()
	return PLATFORM == "IOS"
end

function Platform.IsMac()
	return PLATFORM == "OSX_STEAM"
end

function Platform.IsConsole()
	return Platform.IsPS4() or Platform.IsXB1()
end

function Platform.IsNotConsole()
	return not Platform.IsConsole()
end

-- Behaves similar to console and no keyboard input expected, but
-- not subject to TRCs and has better perf and mods.
function Platform.IsLikeConsole()
	return Platform.IsConsole()
		or Platform.IsSteamDeck()
		or Platform.IsBigPictureMode()
end

function Platform.IsSteamDeck()
	return IS_STEAM_DECK
end

function Platform.IsBigPictureMode()
	return IS_BIG_PICTURE_MODE
end

function Platform.ShouldIgnoreMouse()
	-- We don't want this for steamdeck since it prevents using the touch screen.
	return Platform.IsConsole()
end

return Platform
